// Copyright (c) Microsoft Corporation. All rights reserved.

function OnFinish(selProj, selObj)
{
	try
	{
		wizard.AddSymbol("SAFE_PROJECT_HELP_FILE_NAME", CreateSafeName(wizard.FindSymbol("PROJECT_NAME")));
		wizard.AddSymbol("RC2_FILE_NAME", CreateASCIIName(wizard.FindSymbol("PROJECT_NAME")));
		wizard.AddSymbol("RC_FILE_NAME",CreateSafeRCFileName(wizard.FindSymbol("PROJECT_NAME")) + ".rc");

		if(wizard.FindSymbol("AUTOMATION"))
			wizard.AddSymbol("SAFE_IDL_NAME", CreateASCIIName(wizard.FindSymbol("PROJECT_NAME")));
		var bOLEDB = wizard.FindSymbol("OLEDB");
		if (bOLEDB)
		{
			var strRowsetClass = wizard.FindSymbol("ROWSET_CLASS");
			var bAttributed = wizard.FindSymbol("ATTRIBUTED");
			var strCode = wizard.GetConsumerClass(strRowsetClass, bAttributed);
			wizard.AddSymbol("ROWSET_CLASS_CODE", strCode);
		}
		else
		{
			var bODBC = wizard.FindSymbol("ODBC");
			if (bODBC)
			{
				var strRowsetClass = wizard.FindSymbol("ROWSET_CLASS");
				var bSnapshot = wizard.FindSymbol("SNAPSHOT");
				var bBindAllColumns = wizard.FindSymbol("BIND_ALL_COLUMNS");
				var strCodeDecl = wizard.GetODBCConsumerClassDecl(bBindAllColumns, bSnapshot, strRowsetClass);
				var strCodeImpl = wizard.GetODBCConsumerClassImpl();
				wizard.AddSymbol("ROWSET_CLASS_ODBC_DECL", strCodeDecl);
				wizard.AddSymbol("ROWSET_CLASS_ODBC_IMPL", strCodeImpl);
			}
		}

		var strProjectPath = wizard.FindSymbol("PROJECT_PATH");
		var strProjectName = wizard.FindSymbol("PROJECT_NAME");

		selProj = CreateProject(strProjectName, strProjectPath);

		AddCommonConfig(selProj, strProjectName,wizard.FindSymbol("UNICODE"));
		AddSpecificConfig(selProj, strProjectName, strProjectPath);

		SetupFilters(selProj);

		var bContextHelp = wizard.FindSymbol("CONTEXT_HELP");
		var bHTMLHelp = wizard.FindSymbol("HELPSTYLE_HTML");
		var L_strHelpFiles_Text = "ļ";
		if (bContextHelp)
		{
			if (bHTMLHelp)
			{
				var strHelpFilter = wizard.FindSymbol("HTMLHELP_FILTER");
                var L_strHTMLHelpFiles_Text = "HTML ļ";
				var group = selProj.Object.AddFilter(L_strHTMLHelpFiles_Text);
				group.Filter = strHelpFilter;

				var strHelpFilter = wizard.FindSymbol("HTMLHELP_TOPICSFILTER");
                var L_strHelpTopics_Text = "HTML ";
				var group = selProj.Object.AddFilter(L_strHelpTopics_Text);
				group.Filter = strHelpFilter;
			}
			else
			{
				var strHelpFilter = wizard.FindSymbol("HELP_FILTER");
				var group = selProj.Object.AddFilter(L_strHelpFiles_Text);
				group.Filter = strHelpFilter;
			}
		}
		
		var strDocTypeName = wizard.FindSymbol("DOC_TYPE_NAME"); 		
		if (strDocTypeName != "" )
		{
			wizard.AddSymbol("SAFE_DOC_TYPE_NAME", CreateSafeName(strDocTypeName));
		}
		
		selProj.Object.keyword = "MFCProj";

		SetResDlgFont();

		AddFilesToProjectWithInfFile(selProj, strProjectName);
		SetCommonPchSettings(selProj);

		if (bContextHelp && !bHTMLHelp)
			AddHelpImages(selProj, L_strHelpFiles_Text);
		
		selProj.Object.Save();

		if (wizard.FindSymbol("APP_TYPE_DLG"))
		{
			var strDialogId = "IDD_" + wizard.FindSymbol("UPPER_CASE_SAFE_PROJECT_IDENTIFIER_NAME") + "_DIALOG";
			var oResHelper = wizard.ResourceHelper;
			oResHelper.OpenResourceFile(strProjectPath + "\\" + strProjectName + ".rc");
			oResHelper.OpenResourceInEditor("Dialog", strDialogId);
		}
		if (bContextHelp)
			AddHelpBuildSteps(selProj.Object, strProjectName, bHTMLHelp);

        var fUnicode = wizard.FindSymbol("UNICODE");
        fUnicode = (fUnicode == true);
		SetAllConfigCharset(selProj,fUnicode);
	}
	catch(e)
	{
		if (e.description.length != 0)
			SetErrorInfo(e);
		return e.number
	}
}

function SetFileProperties(projfile, strName)
{
	return false;
}

function AddSpecificConfig(proj, strProjectName, strProjectPath)
{
	try
	{
		var bAutomation = wizard.FindSymbol("AUTOMATION");
		var bServer = wizard.FindSymbol("MINI_SERVER");
		var bDynamicMFC = wizard.FindSymbol("DYNAMIC_MFC");

		if (!bServer)
		{
			bServer = wizard.FindSymbol("FULL_SERVER");
			if (!bServer)
				bServer = wizard.FindSymbol("CONTAINER_SERVER");
		}
		var oConfigs = proj.Object.Configurations;
		for (var nCntr = 1; nCntr <= oConfigs.Count; nCntr++)
		{
			var config = oConfigs(nCntr);
			var bDebug = false;
			if (-1 != config.Name.indexOf("Debug"))
				bDebug = true;
			config.CharacterSet = charSetUNICODE;

			var CLTool = config.Tools("VCCLCompilerTool");

			if (bDynamicMFC)
			{
				config.UseOfMFC = useMfcDynamic;
				CLTool.RuntimeLibrary = (bDebug ? rtMultiThreadedDebugDLL : rtMultiThreadedDLL);
			}
			else
			{
				config.UseOfMFC = useMfcStatic;
				CLTool.RuntimeLibrary = (bDebug ? rtMultiThreadedDebug : rtMultiThreaded);
			}
			var strDefines = CLTool.PreprocessorDefinitions;
			if (strDefines != "") strDefines += ";";
			strDefines += GetPlatformDefine(config);
			if(bDebug)
			{
				strDefines += "_WINDOWS;_DEBUG";
				CLTool.DebugInformationFormat = debugEditAndContinue;
			}
			else
			{
				strDefines += "_WINDOWS;NDEBUG";
				CLTool.MinimalRebuild = false;
				CLTool.DebugInformationFormat = debugEnabled;
			}
			CLTool.PreprocessorDefinitions= strDefines;

			var LinkTool = config.Tools("VCLinkerTool");
			LinkTool.GenerateDebugInformation = true;

			LinkTool.LinkIncremental = (bDebug ? linkIncrementalYes : linkIncrementalNo);

			var bRibbon = wizard.FindSymbol("RIBBON_TOOLBAR");
			var bTabbedMDI = wizard.FindSymbol("APP_TYPE_TABBED_MDI");
			var bDBSupportHeaderOnly = wizard.FindSymbol("DB_SUPPORT_HEADER_ONLY");

			var bOLEDB = wizard.FindSymbol("OLEDB");
			var bSupportOLEDB = wizard.FindSymbol("DB_SUPPORT_OLEDB");
			if (bOLEDB || (bDBSupportHeaderOnly && bSupportOLEDB))
			{
				LinkTool.AdditionalDependencies = "msdasc.lib";
			}

			var bODBC = wizard.FindSymbol("ODBC");
			var bSupportODBC = wizard.FindSymbol("DB_SUPPORT_ODBC");
			if (bODBC || (bDBSupportHeaderOnly && bSupportODBC))
			{
				LinkTool.AdditionalDependencies = "odbc32.lib";
			}

			var MidlTool = config.Tools("VCMidlTool");
			MidlTool.MkTypLibCompatible = false;
			
			// no /no_robust
			MidlTool.ValidateParameters = true;
			MidlTool.PreprocessorDefinitions = (bDebug ? "_DEBUG" : "NDEBUG");

			if (bAutomation)
			{
				var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");
				MidlTool.TypeLibraryName = "$(IntDir)/" + strIdlName + ".tlb";
			}

			var RCTool = config.Tools("VCResourceCompilerTool");
			RCTool.Culture = wizard.FindSymbol("LCID");
			RCTool.PreprocessorDefinitions = (bDebug ? "_DEBUG" : "NDEBUG");
			RCTool.AdditionalIncludeDirectories = "$(IntDir)";

			if (bServer || bAutomation)
			{
				LinkTool.RegisterOutput = true;
			}
		} //for
	}
	catch(e)
	{
		throw e;
	}
}

function GetTargetName(strName, strProjectName, strResPath, strHelpPath)
{
	try
	{
		var strTarget = strName;
		var strSafeProjHelpFileName = wizard.FindSymbol("SAFE_PROJECT_HELP_FILE_NAME");
		var strRC2FileName = wizard.FindSymbol("RC2_FILE_NAME");
		if (strName.substr(0, 4) == "root")
		{
			if (strName == "root.ico" || strName == "root.manifest")
			{
				strTarget = strResPath + "\\" + strProjectName + strName.substr(4);
			}
			else if (strName == "root.rc2")
			{
				strTarget = strResPath + "\\" + strRC2FileName + strName.substr(4);
			}
			else if (strName == "root.hpj" || strName == "root.cnt")
			{
				strTarget = strProjectName + strName.substr(4);
				strTarget = strHelpPath + "\\" + strTarget;
			}
			else if (strName == "root.hhc" || 
				strName == "root.hhk" || 
				strName == "root.hhp")
			{
				strTarget = strSafeProjHelpFileName + strName.substr(4);
				strTarget = strHelpPath + "\\" + strTarget;
			}
			else if (strName == "root.idl")
			{
				var strProjectName = wizard.FindSymbol("SAFE_IDL_NAME");
				strTarget = strProjectName + ".idl";
			}
			else
				strTarget = strProjectName + strName.substr(4);
			return strTarget;
		}
		if (strName.substr(0, 7) == "dlgroot")
		{
			var strExtension = strName.substr(7);

			if (strName == "dlgroot.cnt")
			{
				strTarget = strHelpPath + "\\" + strProjectName + strExtension;
			}
			else if (strName == "dlgroot.hhc")
			{
				strTarget = strHelpPath + "\\" + strSafeProjHelpFileName + strExtension;
			}
			else
			{
				strTarget = strProjectName + strExtension;
			}

			return strTarget;
		}

		switch (strName)
		{
			case "readme.txt":
				strTarget = "ReadMe.txt";
				break;
			case "all.rc":
			case "dlgall.rc":
				strTarget = wizard.FindSymbol("RC_FILE_NAME");
				break;
			case "dlgres.h":
			case "resource.h":
				strTarget = "Resource.h";
				break;
			case "dialog.h":
				strTarget = wizard.FindSymbol("DIALOG_HEADER");
				break;
			case "dialog.cpp":
				strTarget = wizard.FindSymbol("DIALOG_IMPL");
				break;
			case "dlgproxy.h":
				strTarget = wizard.FindSymbol("DIALOG_AUTO_PROXY_HEADER");
				break;
			case "dlgproxy.cpp":
				strTarget = wizard.FindSymbol("DIALOG_AUTO_PROXY_IMPL");
				break;
			case "frame.h":
				strTarget = wizard.FindSymbol("MAIN_FRAME_HEADER");
				break;
			case "frame.cpp":
				strTarget = wizard.FindSymbol("MAIN_FRAME_IMPL");
				break;
			case "childfrm.h":
				strTarget = wizard.FindSymbol("CHILD_FRAME_HEADER");
				break;
			case "childfrm.cpp":
				strTarget = wizard.FindSymbol("CHILD_FRAME_IMPL");
				break;
			case "doc.h":
				strTarget = wizard.FindSymbol("DOC_HEADER");
				break;
			case "doc.cpp":
				strTarget = wizard.FindSymbol("DOC_IMPL");
				break;
			case "view.h":
				strTarget = wizard.FindSymbol("VIEW_HEADER");
				break;
			case "view.cpp":
				strTarget = wizard.FindSymbol("VIEW_IMPL");
				break;
			case "wndview.h":
				strTarget = wizard.FindSymbol("WND_VIEW_HEADER");
				break;
			case "wndview.cpp":
				strTarget = wizard.FindSymbol("WND_VIEW_IMPL");
				break;
			case "treeview.h":
				strTarget = wizard.FindSymbol("TREE_VIEW_HEADER");
				break;
			case "treeview.cpp":
				strTarget = wizard.FindSymbol("TREE_VIEW_IMPL");
				break;
			case "recset.h":
				strTarget = wizard.FindSymbol("ROWSET_HEADER");
				break;
			case "recset.cpp":
				strTarget = wizard.FindSymbol("ROWSET_IMPL");
				break;
			case "srvritem.h":
				strTarget = wizard.FindSymbol("SERVER_ITEM_HEADER");
				break;
			case "srvritem.cpp":
				strTarget = wizard.FindSymbol("SERVER_ITEM_IMPL");
				break;
			case "ipframe.h":
				strTarget = wizard.FindSymbol("INPLACE_FRAME_HEADER");
				break;
			case "ipframe.cpp":
				strTarget = wizard.FindSymbol("INPLACE_FRAME_IMPL");
				break;
			case "cntritem.h":
				strTarget = wizard.FindSymbol("CONTAINER_ITEM_HEADER");
				break;
			case "cntritem.cpp":
				strTarget = wizard.FindSymbol("CONTAINER_ITEM_IMPL");
				break;
			case "viewtree.h":
				strTarget = "ViewTree.h";
				break;
			case "viewtree.cpp":
				strTarget = "ViewTree.cpp";
				break;
			case "classview.h":
				strTarget = "ClassView.h";
				break;
			case "classview.cpp":
				strTarget = "ClassView.cpp";
				break;
			case "fileview.h":
				strTarget = "FileView.h";
				break;
			case "fileview.cpp":
				strTarget = "FileView.cpp";
				break;
			case "outputwnd.h":
				strTarget = "OutputWnd.h";
				break;
			case "outputwnd.cpp":
				strTarget = "OutputWnd.cpp";
				break;
			case "propertieswnd.h":
				strTarget = "PropertiesWnd.h";
				break;
			case "propertieswnd.cpp":
				strTarget = "PropertiesWnd.cpp";
				break;
			case "calendarbar.h":
				strTarget = "CalendarBar.h";
				break;
			case "calendarbar.cpp":
				strTarget = "CalendarBar.cpp";
				break;
			case "userimages.bmp":
				strTarget = "UserImages.bmp";
				break;
			case "doc.ico":
				strTarget = strResPath + "\\" + strProjectName + "Doc.ico";
				break;
			case "file_view.ico":
			case "file_view_hc.ico":
			case "fileview.bmp":
			case "fileview_hc.bmp":
			case "class_view.ico":
			case "class_view_hc.ico":
			case "classview.bmp":
			case "classview_hc.bmp":
			case "output_wnd.ico":
			case "output_wnd_hc.ico":
			case "properties_wnd.ico":
			case "properties_wnd_hc.ico":
			case "properties.bmp":
			case "properties_hc.bmp":
			case "explorer.bmp":
			case "explorer_hc.bmp":
			case "sort.bmp":
			case "sort_hc.bmp":
			case "nav_large.bmp":
			case "nav_large_hc.bmp":
			case "pages.bmp":
			case "pages_hc.bmp":
			case "pages_small.bmp":
			case "pages_small_hc.bmp":
			case "menuimages.bmp":
			case "menuimages_hc.bmp":
			case "info.bmp":
				strTarget = strResPath + "\\" + strTarget;
				break;
			case "afxdlg.rtf":
				strTarget = strHelpPath + "\\" + strTarget;
				break;
			case "afxdlg.htm":
			case "afxcore.htm":
				strTarget = strHelpPath + "\\" + strTarget;
				break;
			case "HIDD_ROOT_DIALOG.htm":
			case "afxo0001.htm":
			case "afx_hidd_changeicon.htm":
			case "afx_hidd_color.htm":
			case "afx_hidd_convert.htm":
			case "afx_hidd_editlinks.htm":
			case "afx_hidd_fileopen.htm":
			case "afx_hidd_filesave.htm":
			case "afx_hidd_find.htm":
			case "afx_hidd_font.htm":
			case "afx_hidd_insertobject.htm":
			case "afx_hidd_newtypedlg.htm":
			case "afx_hidd_pastespecial.htm":
			case "afx_hidd_print.htm":
			case "afx_hidd_printdlg.htm":
			case "afx_hidd_printsetup.htm":
			case "afx_hidd_replace.htm":
			case "afx_hidp_default.htm":
			case "afx_hidw_dockbar_top.htm":
			case "afx_hidw_preview_bar.htm":
			case "afx_hidw_resize_bar.htm":
			case "afx_hidw_status_bar.htm":
			case "afx_hidw_toolbar.htm":
			case "hidr_doc1type.htm":
			case "hid_app_about.htm":
			case "hid_app_exit.htm":
			case "hid_context_help.htm":
			case "hid_edit_clear.htm":
			case "hid_edit_clear_all.htm":
			case "hid_edit_copy.htm":
			case "hid_edit_cut.htm":
			case "hid_edit_find.htm":
			case "hid_edit_paste.htm":
			case "hid_edit_paste_link.htm":
			case "hid_edit_redo.htm":
			case "hid_edit_repeat.htm":
			case "hid_edit_replace.htm":
			case "hid_edit_undo.htm":
			case "hid_file_close.htm":
			case "hid_file_mru_file1.htm":
			case "hid_file_new.htm":
			case "hid_file_open.htm":
			case "hid_file_page_setup.htm":
			case "hid_file_print.htm":
			case "hid_file_print_preview.htm":
			case "hid_file_print_setup.htm":
			case "hid_file_save.htm":
			case "hid_file_save_as.htm":
			case "hid_file_save_copy_as.htm":
			case "hid_file_send_mail.htm":
			case "hid_file_update.htm":
			case "hid_help_index.htm":
			case "hid_help_using.htm":
			case "hid_ht_caption.htm":
			case "hid_ht_nowhere.htm":
			case "hid_next_pane.htm":
			case "hid_ole_edit_links.htm":
			case "hid_ole_insert_new.htm":
			case "hid_ole_verb_1.htm":
			case "hid_prev_pane.htm":
			case "hid_record_first.htm":
			case "hid_record_last.htm":
			case "hid_record_next.htm":
			case "hid_record_prev.htm":
			case "hid_sc_close.htm":
			case "hid_sc_maximize.htm":
			case "hid_sc_minimize.htm":
			case "hid_sc_move.htm":
			case "hid_sc_nextwindow.htm":
			case "hid_sc_prevwindow.htm":
			case "hid_sc_restore.htm":
			case "hid_sc_size.htm":
			case "hid_sc_tasklist.htm":
			case "hid_view_ruler.htm":
			case "hid_view_status_bar.htm":
			case "hid_view_toolbar.htm":
			case "hid_window_all.htm":
			case "hid_window_arrange.htm":
			case "hid_window_cascade.htm":
			case "hid_window_new.htm":
			case "hid_window_split.htm":
			case "hid_window_tile.htm":
			case "hid_window_tile_horz.htm":
			case "hid_window_tile_vert.htm":
			case "main_index.htm":
			case "menu_edit.htm":
			case "menu_file.htm":
			case "menu_help.htm":
			case "menu_record.htm":
			case "menu_view.htm":
			case "menu_window.htm":
			case "scrollbars.htm":
				strTarget = strHelpPath + "\\" + strTarget;
				break;
			default:
				break;
		}

		var strTemp = GetAdditionalPath(strTarget, strResPath, strHelpPath);


		strTarget = strTemp;
		return strTarget; 
	}
	catch(e)
	{
		throw e;
	}
}

function GetAdditionalPath(strName, strResPath, strHelpPath)
{
	try
	{
		var strFullName = strName;
		switch(strName)
		{
			case "afxcore.rtf":
			case "afxprint.rtf":
			case "afxolecl.rtf":
			case "afxolesv.rtf":
			case "afxdb.rtf":
				strFullName = strHelpPath + "\\" + strName;
				break;
			case "Bullet.gif":
				strFullName = strHelpPath + "\\Images\\" + strName;
				break;
			case "buttons.bmp":
			case "filelarge.bmp":
			case "filesmall.bmp":
			case "main.bmp":
			case "writelarge.bmp":
			case "writesmall.bmp":
				strFullName = strResPath + "\\" + strName;
				break;
			case "tbdh_.bmp":
			case "tbd__.bmp":
			case "tbrh_.bmp":
			case "tbr__.bmp":
			case "tbah_.bmp":
			case "tba__.bmp":
			case "tbedh.bmp":
			case "tbed_.bmp":
			case "tbeah.bmp":
			case "tbea_.bmp":
			case "tbndm.bmp":
			case "tbndmh.bmp":
			case "tbnds.bmp":
			case "tbndsh.bmp":
				strFullName = strResPath + "\\Toolbar.bmp";
				break;
			case "tbah_256.bmp":
			case "tba__256.bmp":
			case "tbdh_256.bmp":
			case "tbd__256.bmp":
			case "tbeah_256.bmp":
			case "tbea_256.bmp":
			case "tbedh_256.bmp":
			case "tbed_256.bmp":
			case "tbrh_256.bmp":
			case "tbr__256.bmp":
			case "tbndmh256.bmp":
			case "tbndm256.bmp":
			case "tbndsh256.bmp":
			case "tbnds256.bmp":
				strFullName = strResPath + "\\Toolbar256.bmp";
				break;
			case "tba_i.bmp":
			case "tbrhi.bmp":
			case "tbr_i.bmp":
			case "tbahi.bmp":
				strFullName = strResPath + "\\IToolbar.bmp";
				break;
			case "tba_i256.bmp":
			case "tbrhi256.bmp":
			case "tbr_i256.bmp":
			case "tbahi256.bmp":
				strFullName = strResPath + "\\IToolbar256.bmp";
				break;
			case "bullet.bmp":
				strFullName = "";  // Help image files - will be added to the project in AddHelpImages
				break;
			default:
				break;
		}
		return strFullName;
	}
	catch(e)
	{
		throw e;
	}
}

function AddHelpBuildSteps(projObj, strProjectName, bHTMLHelp)
{
	try
	{
		var fileExt;
		var outFileExt;
		var fileTool1 = "";
		var fileTool2 = "";
		var extraMakehmSwitch = "";
		var extraMakehmSwitch2 = "";
		var strCodeTool1 = new Array();
		var strCodeTool2 = new Array();
		var strHmFileName;
		var strHmFileNameNoQuotes;
		var strHmHeaderComment;
		var strSafeProjHelpFileName = wizard.FindSymbol("SAFE_PROJECT_HELP_FILE_NAME");

		if(bHTMLHelp)
		{
			fileExt = ".hhp";
			outFileExt = ".chm";
			strHmFileName = "\"hlp\\HTMLDefines.h\"";
			strHmFileNameNoQuotes = "hlp\\HTMLDefines.h";
			extraMakehmSwitch = "/h ";
			extraMakehmSwitch2 = "/a afxhh.h "
			var L_strCodeFragment1_Text = "ɵİӳļʹΪ";
			strHmHeaderComment = L_strCodeFragment1_Text + strSafeProjHelpFileName + ".HHP.";

			// put together the command line to apply to the .hhp file
			strCodeTool1[0] = "start /wait hhc \"hlp\\" + strSafeProjHelpFileName + ".hhp\"";
			strCodeTool1[1] = "if not exist \"hlp\\" + strSafeProjHelpFileName + ".chm\" goto :HelpError";
			strCodeTool1[2] = "copy \"hlp\\" + strSafeProjHelpFileName + ".chm\" \"$(OutDir)\\" + strProjectName + ".chm\"";
			strCodeTool1[3] = "goto :HelpDone";
			strCodeTool1[4] = ":HelpError";
			var strLine1 = "echo hlp\\" + strSafeProjHelpFileName + ".hhp(1) : error:";
			var L_strCodeFragment2_Text = "ļʱ";
			strLine1 += L_strCodeFragment2_Text;
			strCodeTool1[5] = strLine1;
			strCodeTool1[6] = "echo.";
			strCodeTool1[7] = ":HelpDone";
			strCodeTool1[8] = "echo.";
			var idx;
			for (idx=0; idx<9; idx++)
				fileTool1 += strCodeTool1[idx] + "\r\n";
		}
		else
		{
			fileExt = ".hpj";
			outFileExt = ".hlp";
			strHmFileName = "\"hlp\\$(ProjectName).hm\"";
			strHmFileNameNoQuotes = "hlp\\$(ProjectName).hm";
			var L_strCodeFragment3_Text = "ɵİӳļ $(ProjectName).hpj ʹá";
			strHmHeaderComment = L_strCodeFragment3_Text;

			// put together the command line to apply to the .hpj file
			strCodeTool1[0]  = "start /wait hcw /C /E /M \"hlp\\$(ProjectName).hpj\"";
			strCodeTool1[1]  = "if errorlevel 1 goto :HelpError";
			strCodeTool1[2]  = "if not exist \"hlp\\$(ProjectName).hlp\" goto :HelpError";
			strCodeTool1[3]  = "if not exist \"hlp\\$(ProjectName).cnt\" goto :HelpError";
			strCodeTool1[4]  = "echo.";
			strCodeTool1[5]  = "copy \"hlp\\$(ProjectName).hlp\" \"$(OutDir)\"";
			strCodeTool1[6]  = "copy \"hlp\\$(ProjectName).cnt\" \"$(OutDir)\"";
			strCodeTool1[7]  = "goto :HelpDone";
			strCodeTool1[8]  = ":HelpError";
			var strLine1 = "echo hlp\\$(ProjectName).hpj(1) : error: ";
			var L_strWinCodeToolFragment1_Text = "ļʱ";
			strLine1 += L_strWinCodeToolFragment1_Text;
			strCodeTool1[9]  = strLine1;
			strCodeTool1[10] = ":HelpDone";
			strCodeTool1[11] = "echo.";
			var idx;
			for (idx=0; idx<12; idx++)
				fileTool1 += strCodeTool1[idx] + "\r\n";
		}

		// put together the command line to apply to the resource.h file
		var strLine = "echo // ";
		strLine += strHmHeaderComment;
		strLine += " > " + strHmFileName;
		strCodeTool2[0]  = strLine;
		strCodeTool2[1]  = "echo. > " + strHmFileName;
		strLine = "echo // ";
		var L_strCodeFragment4_Text = "(ID_*  IDM_*)";
		strLine += L_strCodeFragment4_Text;
		strLine += " >> " + strHmFileName;
		strCodeTool2[2]  = strLine;
		strCodeTool2[3]  = "makehm " + extraMakehmSwitch + "ID_,HID_,0x10000 IDM_,HIDM_,0x10000 \"$(InputFileName)\" >> " + strHmFileName;
		strCodeTool2[4]  = "echo. >> " + strHmFileName;
		strLine = "echo // ";
		var L_strCodeFragment5_Text = "ʾ(IDP_*)";
		strLine += L_strCodeFragment5_Text;
		strLine += " >> " + strHmFileName;
		strCodeTool2[5]  = strLine;
		strCodeTool2[6]  = "makehm " + extraMakehmSwitch + "IDP_,HIDP_,0x30000 \"$(InputFileName)\" >> " + strHmFileName;
		strCodeTool2[7]  = "echo. >> " + strHmFileName;
		strLine = "echo // ";
		var L_strCodeFragment6_Text = "Դ(IDR_*)";
		strLine += L_strCodeFragment6_Text;
		strLine += " >> " + strHmFileName;
		strCodeTool2[8]  = strLine;
		strCodeTool2[9]  = "makehm " + extraMakehmSwitch + "IDR_,HIDR_,0x20000 \"$(InputFileName)\" >> " + strHmFileName;
		strCodeTool2[10] = "echo. >> " + strHmFileName;
		strLine = "echo // ";
		var L_strCodeFragment7_Text = "Ի(IDD_*)";
		strLine += L_strCodeFragment7_Text;
		strLine += " >> " + strHmFileName;
		strCodeTool2[11] = strLine;
		strCodeTool2[12] = "makehm " + extraMakehmSwitch + "IDD_,HIDD_,0x20000 \"$(InputFileName)\" >> " + strHmFileName;
		strCodeTool2[13] = "echo. >> " + strHmFileName;
		strLine = "echo // ";
		var L_strCodeFragment8_Text = "ܿؼ(IDW_*)";
		strLine += L_strCodeFragment8_Text;
		strLine += " >> " + strHmFileName;
		strCodeTool2[14] = strLine;
		strCodeTool2[15] = "makehm " + extraMakehmSwitch + extraMakehmSwitch2 + "IDW_,HIDW_,0x50000 \"$(InputFileName)\" >> " + strHmFileName;
		for (idx=0; idx<16; idx++)
			fileTool2 += strCodeTool2[idx] + "\r\n";

		var oPch = projObj.Files("StdAfx.cpp");
		if (oPch != null)
		{
			for (var n=1; n<=oPch.FileConfigurations.Count; n++)
			{
				var config = oPch.FileConfigurations.Item(n)
				config.Tool.UsePrecompiledHeader = pchCreateUsingSpecific;
			}
		}
		
		var fileObj1;
		if(bHTMLHelp)
		{
			fileObj1 = projObj.Files(strSafeProjHelpFileName + fileExt);
		}
		else
		{
			fileObj1 = projObj.Files(strProjectName + fileExt);
		}
		var fileObj2 = projObj.Files("resource.h");
			
		if (fileObj1 != null)
		{
			for (var i=1; i<=fileObj1.FileConfigurations.Count; i++)
			{
				var config = fileObj1.FileConfigurations.Item(i);
				if (config != null)
				{
					var CustomBuildTool = config.Tool;	
					CustomBuildTool.Outputs = "$(OutDir)\\$(ProjectName)" + outFileExt;
					CustomBuildTool.AdditionalDependencies = strHmFileNameNoQuotes;
					CustomBuildTool.CommandLine = fileTool1;
					L_ToolDesc1_Text = "ɰļ...";
					CustomBuildTool.Description = L_ToolDesc1_Text;
				}
			}
		}

		if (fileObj2 != null)
		{
			for (var i=1; i<=fileObj2.FileConfigurations.Count; i++)
			{
				var config = fileObj2.FileConfigurations.Item(i);
				if (config != null)
				{
					var CustomBuildTool = config.Tool;	
					CustomBuildTool.Outputs = strHmFileNameNoQuotes;
					CustomBuildTool.CommandLine = fileTool2;
					L_ToolDesc2_Text = "ɰӳļ...";
					CustomBuildTool.Description = L_ToolDesc2_Text;
				}
			}
		}
	}
	catch(e)
	{
		throw e;
	}
}

function AddHelpImages(selProj, L_strHelpFiles_Text)
{
	try
	{
		var oHelpFolder = selProj.Object.Filters.Item(L_strHelpFiles_Text);
		strHelpPath = wizard.FindSymbol("HELP_PATH");
		oHelpFolder.AddFile(strHelpPath + "\\Images\\bullet.bmp");
	}
	catch(e)
	{
		throw e;
	}
}

// SIG // Begin signature block
// SIG // MIIj6gYJKoZIhvcNAQcCoIIj2zCCI9cCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFIyWUWVj8k6d
// SIG // lpvjefs3leMz0G97oIIe4TCCBBIwggL6oAMCAQICDwDB
// SIG // AIs8PIgR0T72Y+zfQDANBgkqhkiG9w0BAQQFADBwMSsw
// SIG // KQYDVQQLEyJDb3B5cmlnaHQgKGMpIDE5OTcgTWljcm9z
// SIG // b2Z0IENvcnAuMR4wHAYDVQQLExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xITAfBgNVBAMTGE1pY3Jvc29mdCBSb290
// SIG // IEF1dGhvcml0eTAeFw05NzAxMTAwNzAwMDBaFw0yMDEy
// SIG // MzEwNzAwMDBaMHAxKzApBgNVBAsTIkNvcHlyaWdodCAo
// SIG // YykgMTk5NyBNaWNyb3NvZnQgQ29ycC4xHjAcBgNVBAsT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMY
// SIG // TWljcm9zb2Z0IFJvb3QgQXV0aG9yaXR5MIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqQK9wXDmO/JO
// SIG // Gyifl3heMOqiqY0lX/j+lUyjt/6doiA+fFGim6KPYDJr
// SIG // 0UJkee6sdslU2vLrnIYcj5+EZrPFa3piI9YdPN4PAZLo
// SIG // lsS/LWaammgmmdA6LL8MtVgmwUbnCj44liypKDmo7EmD
// SIG // QuOED7uabFVhrIJ8oWAtd0zpmbRkO5pQHDEIJBSfqeeR
// SIG // KxjmPZhjFGBYBWWfHTdSh/en75QCxhvTv1VFs4mAvzrs
// SIG // VJROrv2nem10Tq8YzJYJKCEAV5BgaTe7SxIHPFb/W/uk
// SIG // ZgoIptKBVlfvtjteFoF3BNr2vq6Alf6wzX/WpxpyXDzK
// SIG // vPAIoyIwswaFybMgdxOF3wIDAQABo4GoMIGlMIGiBgNV
// SIG // HQEEgZowgZeAEFvQcO9pcp4jUX4Usk2O/8uhcjBwMSsw
// SIG // KQYDVQQLEyJDb3B5cmlnaHQgKGMpIDE5OTcgTWljcm9z
// SIG // b2Z0IENvcnAuMR4wHAYDVQQLExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xITAfBgNVBAMTGE1pY3Jvc29mdCBSb290
// SIG // IEF1dGhvcml0eYIPAMEAizw8iBHRPvZj7N9AMA0GCSqG
// SIG // SIb3DQEBBAUAA4IBAQCV6AvAjfOXGDXtuAEk2HcR81xg
// SIG // Mp+eC8s+BZGIj8k65iHy8FeTLLWgR8hi7/zXzDs7Wqk2
// SIG // VGn+JG0/ycyq3gV83TGNPZ8QcGq7/hJPGGnA/NBD4xFa
// SIG // IE/qYnuvqhnIKzclLb5loRKKJQ9jo/dUHPkhydYV81Ks
// SIG // bkMyB/2CF/jlZ2wNUfa98VLHvefEMPwgMQmIHZUpGk3V
// SIG // HQKl8YDgA7Rb9LHdyFfuZUnHUlS2tAMoEv+Q1vAIj364
// SIG // l8WrNyzkeuSod+N2oADQaj/B0jaK4EESqDVqG2rbNeHU
// SIG // HATkqEUEyFozOG5NHA1itwqijNPVVD9GzRxVpnDbEjqH
// SIG // k3Wfp9KgMIIEEjCCAvqgAwIBAgIPAMEAizw8iBHRPvZj
// SIG // 7N9AMA0GCSqGSIb3DQEBBAUAMHAxKzApBgNVBAsTIkNv
// SIG // cHlyaWdodCAoYykgMTk5NyBNaWNyb3NvZnQgQ29ycC4x
// SIG // HjAcBgNVBAsTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEh
// SIG // MB8GA1UEAxMYTWljcm9zb2Z0IFJvb3QgQXV0aG9yaXR5
// SIG // MB4XDTk3MDExMDA3MDAwMFoXDTIwMTIzMTA3MDAwMFow
// SIG // cDErMCkGA1UECxMiQ29weXJpZ2h0IChjKSAxOTk3IE1p
// SIG // Y3Jvc29mdCBDb3JwLjEeMBwGA1UECxMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQg
// SIG // Um9vdCBBdXRob3JpdHkwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCpAr3BcOY78k4bKJ+XeF4w6qKp
// SIG // jSVf+P6VTKO3/p2iID58UaKboo9gMmvRQmR57qx2yVTa
// SIG // 8uuchhyPn4Rms8VremIj1h083g8BkuiWxL8tZpqaaCaZ
// SIG // 0Dosvwy1WCbBRucKPjiWLKkoOajsSYNC44QPu5psVWGs
// SIG // gnyhYC13TOmZtGQ7mlAcMQgkFJ+p55ErGOY9mGMUYFgF
// SIG // ZZ8dN1KH96fvlALGG9O/VUWziYC/OuxUlE6u/ad6bXRO
// SIG // rxjMlgkoIQBXkGBpN7tLEgc8Vv9b+6RmCgim0oFWV++2
// SIG // O14WgXcE2va+roCV/rDNf9anGnJcPMq88AijIjCzBoXJ
// SIG // syB3E4XfAgMBAAGjgagwgaUwgaIGA1UdAQSBmjCBl4AQ
// SIG // W9Bw72lyniNRfhSyTY7/y6FyMHAxKzApBgNVBAsTIkNv
// SIG // cHlyaWdodCAoYykgMTk5NyBNaWNyb3NvZnQgQ29ycC4x
// SIG // HjAcBgNVBAsTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEh
// SIG // MB8GA1UEAxMYTWljcm9zb2Z0IFJvb3QgQXV0aG9yaXR5
// SIG // gg8AwQCLPDyIEdE+9mPs30AwDQYJKoZIhvcNAQEEBQAD
// SIG // ggEBAJXoC8CN85cYNe24ASTYdxHzXGAyn54Lyz4FkYiP
// SIG // yTrmIfLwV5MstaBHyGLv/NfMOztaqTZUaf4kbT/JzKre
// SIG // BXzdMY09nxBwarv+Ek8YacD80EPjEVogT+pie6+qGcgr
// SIG // NyUtvmWhEoolD2Oj91Qc+SHJ1hXzUqxuQzIH/YIX+OVn
// SIG // bA1R9r3xUse958Qw/CAxCYgdlSkaTdUdAqXxgOADtFv0
// SIG // sd3IV+5lScdSVLa0AygS/5DW8AiPfriXxas3LOR65Kh3
// SIG // 43agANBqP8HSNorgQRKoNWobats14dQcBOSoRQTIWjM4
// SIG // bk0cDWK3CqKM09VUP0bNHFWmcNsSOoeTdZ+n0qAwggRg
// SIG // MIIDTKADAgECAgouqxHcUP9cncvAMAkGBSsOAwIdBQAw
// SIG // cDErMCkGA1UECxMiQ29weXJpZ2h0IChjKSAxOTk3IE1p
// SIG // Y3Jvc29mdCBDb3JwLjEeMBwGA1UECxMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQg
// SIG // Um9vdCBBdXRob3JpdHkwHhcNMDcwODIyMjIzMTAyWhcN
// SIG // MTIwODI1MDcwMDAwWjB5MQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWduaW5n
// SIG // IFBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBALd5fdZds0U5qDSsMdr5JTVJd8D7H57HRXHv0Ubo
// SIG // 1IzDa0xSYvSZAsNN2ElsLyQ+Zb/OI7cLSLd/dd1FvaqP
// SIG // DlDFJSvyoOcNIx/RQST6YpnPGUWlk0ofmc2zLyLDSi18
// SIG // b9kVHjuMORA53b0p9GY7LQEy//4nSKa1bAGHnPu6smN/
// SIG // gvlcoIGEhY6w8riUo884plCFFyeHTt0w9gA99Mb5PYG+
// SIG // hu1sOacuNPa0Lq8KfWKReGacmHMNhq/yxPMguU8SjWPL
// SIG // LNkyRRnuu0qWO1BTGM5mUXmqrYfIVj6fglCIbgWxNcF7
// SIG // JL1SZj2ZTswrfjNuhEcG0Z7QSoYCboYApMCH31MCAwEA
// SIG // AaOB+jCB9zATBgNVHSUEDDAKBggrBgEFBQcDAzCBogYD
// SIG // VR0BBIGaMIGXgBBb0HDvaXKeI1F+FLJNjv/LoXIwcDEr
// SIG // MCkGA1UECxMiQ29weXJpZ2h0IChjKSAxOTk3IE1pY3Jv
// SIG // c29mdCBDb3JwLjEeMBwGA1UECxMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgUm9v
// SIG // dCBBdXRob3JpdHmCDwDBAIs8PIgR0T72Y+zfQDAPBgNV
// SIG // HRMBAf8EBTADAQH/MB0GA1UdDgQWBBTMHc52AHBbr/Ha
// SIG // xE6aUUQuo0Rj8DALBgNVHQ8EBAMCAYYwCQYFKw4DAh0F
// SIG // AAOCAQEAe6uufkom8s68TnSiWCd0KnWzhv2rTJR4AE3p
// SIG // yusY3GnFDqJ88wJDxsqHzPhTzMKfvVZv8GNEqUQA7pbI
// SIG // mtUcuAufGQ2U19oerSl97+2mc6yP3jmOPZhqvDht0oiv
// SIG // I/3f6dZpCZGIvf7hALs08/d8+RASLgXrKZaTQmsocbc4
// SIG // j+AHDcldaM29gEFrZqi7t7uONMryAxB8evXS4ELfe/7h
// SIG // 4az+9t/VDbNw1pLjT7Y4onwt1D3bNAtiNwKfgWojifZc
// SIG // Y4+wWrs512CMVYQaM/U7mKCCDKJfi7Mst6Gly6vaILa/
// SIG // MBmFIBQNKrxS9EHgXjDjkihph8Fw4vOnq86AQnJ2DjCC
// SIG // BGowggNSoAMCAQICCmEPeE0AAAAAAAMwDQYJKoZIhvcN
// SIG // AQEFBQAweTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UE
// SIG // AxMaTWljcm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwHhcN
// SIG // MDcwODIzMDAyMzEzWhcNMDkwMjIzMDAzMzEzWjB0MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMR4wHAYDVQQDExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCi2wqNz8LBSZvNqjo0rSNZa9ts
// SIG // viEit5TI6q6/xtUmwjIRi7zaXSz7NlYeFSuujw3dFKNu
// SIG // KEx/Fj9BrI1AsUaIDdmBlK2XBtBXRHZc6vH8DuJ/dKMz
// SIG // y3Tl7+NhoX4Dt0X/1T4S1bDKXg3Qe/K3Ew38YGoohXWM
// SIG // t628hegXtJC+9Ra2Yl3tEd867iFbi6+Ac8NF45WJd2Cb
// SIG // 5613wTeNMxQvE9tiya4aqU+YZ63UIDkwceCNZ0bixhz0
// SIG // DVB0QS/oBSRqIWtJsJLEsjnHQqVtXBhKq4/XjoM+eApH
// SIG // 2KSyhCPD4vJ7ZrFKdL0mQUucYRRgTjDIgvPQC3B87lVN
// SIG // d9IIVXaBAgMBAAGjgfgwgfUwDgYDVR0PAQH/BAQDAgbA
// SIG // MB0GA1UdDgQWBBTzIUCOfFH4VEuY5RfXaoM0BS4m6DAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDAzAfBgNVHSMEGDAWgBTM
// SIG // Hc52AHBbr/HaxE6aUUQuo0Rj8DBEBgNVHR8EPTA7MDmg
// SIG // N6A1hjNodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NybC9wcm9kdWN0cy9DU1BDQS5jcmwwSAYIKwYBBQUH
// SIG // AQEEPDA6MDgGCCsGAQUFBzAChixodHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL0NTUENBLmNydDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAQEAQFdvU2eeIIM0AQ7mF0s8
// SIG // revYgX/uDXl0d0+XRxjzABVpfttikKL9Z6Gc5Cgp+lXX
// SIG // mf5Qv14Js7mm7YLzmB5vWfr18eEM04sIPhYXINHAtUVH
// SIG // CCZgVwlLlPAIzLpNbvDiSBIoNYshct9ftq9pEiSU7uk0
// SIG // Cdt+bm+SClLKKkxJqjIshuihzF0mvLw84Fuygwu6NRxP
// SIG // hEVH/7uUoVkHqZbdeL1Xf6WnTszyrZyaQeLLXCQ+3H80
// SIG // R072z8h7neu2yZxjFFOvrZrv17/PoKGrlcp6K4cswMfZ
// SIG // /GwD2r84rfHRXBkXD8D3yoCmEAga3ZAj57ChTD7qsBEm
// SIG // eA7BLLmka8ePPDCCBJ0wggOFoAMCAQICCmFHUroAAAAA
// SIG // AAQwDQYJKoZIhvcNAQEFBQAweTELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IFRpbWVzdGFt
// SIG // cGluZyBQQ0EwHhcNMDYwOTE2MDE1MzAwWhcNMTEwOTE2
// SIG // MDIwMzAwWjCBpjELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEnMCUG
// SIG // A1UECxMebkNpcGhlciBEU0UgRVNOOkQ4QTktQ0ZDQy01
// SIG // NzlDMScwJQYDVQQDEx5NaWNyb3NvZnQgVGltZXN0YW1w
// SIG // aW5nIFNlcnZpY2UwggEiMA0GCSqGSIb3DQEBAQUAA4IB
// SIG // DwAwggEKAoIBAQCbbdyGUegyOzc6liWyz2/uYbVB0hg7
// SIG // Wp14Z7r4H9kIVZKIfuNBU/rsKFT+tdr+cDuVJ0h+Q6Ay
// SIG // LyaBSvICdnfIyan4oiFYfg29Adokxv5EEQU1OgGo6lQK
// SIG // MyyH0n5Bs+gJ2bC+45klprwl7dfTjtv0t20bSQvm08OH
// SIG // bu5GyX/zbevngx6oU0Y/yiR+5nzJLPt5FChFwE82a1Ma
// SIG // p4az5/zhwZ9RCdu8pbv+yocJ9rcyGb7hSlG8vHysLJVq
// SIG // l3PqclehnIuG2Ju9S/wnM8FtMqzgaBjYbjouIkPR+Y/t
// SIG // 8QABDWTAyaPdD/HI6VTKEf/ceCk+HaxYwNvfqtyuZRvT
// SIG // nbxnAgMBAAGjgfgwgfUwHQYDVR0OBBYEFE8YiYrSygB4
// SIG // xuxZDQ/9fMTBIoDeMB8GA1UdIwQYMBaAFG/oTj+XuTSr
// SIG // S4aPvJzqrDtBQ8bQMEQGA1UdHwQ9MDswOaA3oDWGM2h0
// SIG // dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3By
// SIG // b2R1Y3RzL3RzcGNhLmNybDBIBggrBgEFBQcBAQQ8MDow
// SIG // OAYIKwYBBQUHMAKGLGh0dHA6Ly93d3cubWljcm9zb2Z0
// SIG // LmNvbS9wa2kvY2VydHMvdHNwY2EuY3J0MBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMIMA4GA1UdDwEB/wQEAwIGwDANBgkq
// SIG // hkiG9w0BAQUFAAOCAQEANyce9YxA4PZlJj5kxJC8PuNX
// SIG // hd1DDUCEZ76HqCra3LQ2IJiOM3wuX+BQe2Ex8xoT3oS9
// SIG // 6mkcWHyzG5PhCCeBRbbUcMoUt1+6V+nUXtA7Q6q3P7ba
// SIG // YYtxz9R91Xtuv7TKWjCR39oKDqM1nyVhTsAydCt6BpRy
// SIG // AKwYnUvlnivFOlSspGDYp/ebf9mpbe1Ea7rc4BL68K2H
// SIG // DJVjCjIeiU7MzH6nN6X+X9hn+kZL0W0dp33SvgL/826C
// SIG // 84d0xGnluXDMS2WjBzWpRJ6EfTlu/hQFvRpQIbU+n/N3
// SIG // HI/Cmp1X4Wl9aeiDzwJvKiK7NzM6cvrWMB2RrfZQGusT
// SIG // 3jrFt1zNszCCBJ0wggOFoAMCAQICCmFJfO0AAAAAAAUw
// SIG // DQYJKoZIhvcNAQEFBQAweTELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEjMCEGA1UEAxMaTWljcm9zb2Z0IFRpbWVzdGFtcGlu
// SIG // ZyBQQ0EwHhcNMDYwOTE2MDE1NTIyWhcNMTEwOTE2MDIw
// SIG // NTIyWjCBpjELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEnMCUGA1UE
// SIG // CxMebkNpcGhlciBEU0UgRVNOOjEwRDgtNTg0Ny1DQkY4
// SIG // MScwJQYDVQQDEx5NaWNyb3NvZnQgVGltZXN0YW1waW5n
// SIG // IFNlcnZpY2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQDqugVjyNl5roREPqWzxO1MniTfOXYeCdYy
// SIG // Slh40ivZpQeQ7+c9+70mfKP75X1+Ms/ZPYs5N/L42Ds0
// SIG // FtSSgvs07GiFchqP4LhM4LiF8zMKAsGidnM1TF3xt+FK
// SIG // fR24lHjb/x6FFUJGcc5/J1cS0YNPO8/63vaL7T8A49Xe
// SIG // YfkXjUukgTz1aUDq4Ym/B0+6dHvpDOVH6qts8dVngQj4
// SIG // Fsp9E7tz4glM+mL77aA5mjr+6xHIYR5iWNgKVIPVO0tL
// SIG // 4lW9L2AajpIFQ9pd64IKI5cJoAUxZYuTTh5BIaKSkP1F
// SIG // REVvNbFFN61pqWX5NEOxF8I7OeEQjPIah+NUUB87nTGt
// SIG // AgMBAAGjgfgwgfUwHQYDVR0OBBYEFH5y8C4/VingJfdo
// SIG // uAH8S+F+z+M+MB8GA1UdIwQYMBaAFG/oTj+XuTSrS4aP
// SIG // vJzqrDtBQ8bQMEQGA1UdHwQ9MDswOaA3oDWGM2h0dHA6
// SIG // Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1
// SIG // Y3RzL3RzcGNhLmNybDBIBggrBgEFBQcBAQQ8MDowOAYI
// SIG // KwYBBQUHMAKGLGh0dHA6Ly93d3cubWljcm9zb2Z0LmNv
// SIG // bS9wa2kvY2VydHMvdHNwY2EuY3J0MBMGA1UdJQQMMAoG
// SIG // CCsGAQUFBwMIMA4GA1UdDwEB/wQEAwIGwDANBgkqhkiG
// SIG // 9w0BAQUFAAOCAQEAaXqCCQwW0d7PRokuv9E0eoF/JyhB
// SIG // KvPTIZIOl61fU14p+e3BVEqoffcT0AsU+U3yhhUAbuOD
// SIG // HShFpyw5Mt1vmjda7iNSj1QDjT+nnGQ49jbIFEO2Oj6Y
// SIG // yQ3DcYEo82anMeJcXY/5UlLhXOuTkJ1pCUyJ0dF2TDQN
// SIG // auF8RKcrW4NUf0UkGSXEikbFJeMZgGkpFPYXxvAiLIFG
// SIG // Xiv0+abGdz4jb/mmZIWOomINqS0eqOWQPn//sI78l+zx
// SIG // /QSvzUnOWnSs+vMTHxs5zqO01rz0tO7IrfJWHvs88cjW
// SIG // KkS8v5w/fWYYzbIgYwrKQD1lMhl8srg9wSZITiIZmW6M
// SIG // MMHxkTCCBJ0wggOFoAMCAQICEGoLmU/AACWrEdtFH1h6
// SIG // Z6IwDQYJKoZIhvcNAQEFBQAwcDErMCkGA1UECxMiQ29w
// SIG // eXJpZ2h0IChjKSAxOTk3IE1pY3Jvc29mdCBDb3JwLjEe
// SIG // MBwGA1UECxMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEw
// SIG // HwYDVQQDExhNaWNyb3NvZnQgUm9vdCBBdXRob3JpdHkw
// SIG // HhcNMDYwOTE2MDEwNDQ3WhcNMTkwOTE1MDcwMDAwWjB5
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNy
// SIG // b3NvZnQgVGltZXN0YW1waW5nIFBDQTCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANw3bvuvyEJKcRjI
// SIG // zkg+U8D6qxS6LDK7Ek9SyIPtPjPZSTGSKLaRZOAfUIS6
// SIG // wkvRfwX473W+i8eo1a5pcGZ4J2botrfvhbnN7qr9EqQL
// SIG // WSIpL89A2VYEG3a1bWRtSlTb3fHev5+Dx4Dff0wCN5T1
// SIG // wJ4IVh5oR83ZwHZcL322JQS0VltqHGP/gHw87tUEJU05
// SIG // d3QHXcJc2IY3LHXJDuoeOQl8dv6dbG564Ow+j5eecQ5f
// SIG // Kk8YYmAyntKDTisiXGhFi94vhBBQsvm1Go1s7iWbE/jL
// SIG // ENeFDvSCdnM2xpV6osxgBuwFsIYzt/iUW4RBhFiFlG6w
// SIG // HyxIzG+cQ+Bq6H8mjmsCAwEAAaOCASgwggEkMBMGA1Ud
// SIG // JQQMMAoGCCsGAQUFBwMIMIGiBgNVHQEEgZowgZeAEFvQ
// SIG // cO9pcp4jUX4Usk2O/8uhcjBwMSswKQYDVQQLEyJDb3B5
// SIG // cmlnaHQgKGMpIDE5OTcgTWljcm9zb2Z0IENvcnAuMR4w
// SIG // HAYDVQQLExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xITAf
// SIG // BgNVBAMTGE1pY3Jvc29mdCBSb290IEF1dGhvcml0eYIP
// SIG // AMEAizw8iBHRPvZj7N9AMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRv6E4/l7k0q0uGj7yc6qw7QUPG0DAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAlE0RMcJ8ULsRjqFhBwEOjHBFje9zVL0/
// SIG // CQUt/7hRU4Uc7TmRt6NWC96Mtjsb0fusp8m3sVEhG28I
// SIG // aX5rA6IiRu1stG18IrhG04TzjQ++B4o2wet+6XBdRZ+S
// SIG // 0szO3Y7A4b8qzXzsya4y1Ye5y2PENtEYIb923juasxtz
// SIG // niGI2LS0ElSM9JzCZUqaKCacYIoPO8cTZXhIu8+tgzpP
// SIG // sGJY3jDp6Tkd44ny2jmB+RMhjGSAYwYElvKaAkMve0aI
// SIG // uv8C2WX5St7aA3STswVuDMyd3ChhfEjxF5wRITgCHIes
// SIG // BsWWMrjlQMZTPb2pid7oZjeN9CKWnMywd1RROtZyRLIj
// SIG // 9jGCBHUwggRxAgEBMIGHMHkxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xIzAhBgNVBAMTGk1pY3Jvc29mdCBDb2RlIFNpZ25p
// SIG // bmcgUENBAgphD3hNAAAAAAADMAkGBSsOAwIaBQCggaAw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFJ7dgCPHmaz/H83PcoqCCM0cgwIpMEAGCisG
// SIG // AQQBgjcCAQwxMjAwoBaAFABkAGUAZgBhAHUAbAB0AC4A
// SIG // agBzoRaAFGh0dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqG
// SIG // SIb3DQEBAQUABIIBAH0AtJx65M9BHhf3fA5QtfAOIxuA
// SIG // bE5nAty8BDCQh1vz8iI8E4IEXhST4mtfuHCSRF8mxeh0
// SIG // oxsWjtKUXucItbsAcH5W+jGrTlGXYKF2gQZEjXCQhC9V
// SIG // 2wcyEVsveo7wkRRwsfElTuafKn6XPL4ROUx+PAq5bN+r
// SIG // aVbEx7ANfDy/nO7HehIULGsn9jft3SHPf4cohBRLWj0E
// SIG // U+f3pp1p8g2/jZ5FpYgtYvVGXZDvA+/dL5xa9bmy51jS
// SIG // 4PcNK4yn5S3NodYpEcqjU9n5M49KVTT//1P7aiyXWgCW
// SIG // ZELXLEFUI9iT6ndV1xIbVOehJE2pK4uvpZr/ANd21Mrk
// SIG // /9AshuKhggIfMIICGwYJKoZIhvcNAQkGMYICDDCCAggC
// SIG // AQEwgYcweTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UE
// SIG // AxMaTWljcm9zb2Z0IFRpbWVzdGFtcGluZyBQQ0ECCmFJ
// SIG // fO0AAAAAAAUwBwYFKw4DAhqgXTAYBgkqhkiG9w0BCQMx
// SIG // CwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0wODA4
// SIG // MDEwNTAyMDdaMCMGCSqGSIb3DQEJBDEWBBRC1cTfiaN2
// SIG // kfJiYQhZkm/FfUVR3TANBgkqhkiG9w0BAQUFAASCAQA9
// SIG // NPhW5LrCp3tBfetLux96Jpsom+k/PCknIv0j6Ec6nEOa
// SIG // 33UCRwEyj1jidKtYe8JvGAhzmywf8lopcIlR8Imu65AO
// SIG // r5RjCm3srThIrwEYEG2SiJJesi77AQ61I4+i9CyV54Ck
// SIG // HoRnmHlfWBEY2cBdguXkn1R7A4QlYXQSQ7/YoU4ahYYd
// SIG // dS0geI/Ah/l9BfgBeKfG5RChS0C5XyHpzr3W5n6aTcOx
// SIG // mbUIaXvDniRBrsR/vk9zENDXK6yGTiZNZTNtbVOZ5WVx
// SIG // anCPQJp4dfchlnzFkAwUYRDlNJQoJcawM6WNae09p4oo
// SIG // WZC8oKFnBqGQWu/DJa32PVPCjaPein0+
// SIG // End signature block
